<!DOCTYPE html> 
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>AI Image Story Creator</title>

<!-- Bootstrap 5 CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

<style>
@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap');

* { margin:0; padding:0; box-sizing:border-box; }

body {
    font-family:'Poppins', sans-serif;
    min-height:100vh;
    background: linear-gradient(135deg,#667eea 0%,#764ba2 100%);
    display:flex;
    align-items:center;
    justify-content:center;
    padding:15px;
    position:relative;
}

/* Animated Background Pattern */
body::before {
    content:'';
    position:fixed;
    top:0; left:0;
    width:100%;
    height:100%;
    background: radial-gradient(circle at 20% 50%, rgba(120,40,200,0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(255,100,200,0.1) 0%, transparent 50%),
                radial-gradient(circle at 40% 20%, rgba(100,200,255,0.1) 0%, transparent 50%);
    animation: moveGradient 20s ease infinite;
    z-index:0;
}

@keyframes moveGradient {
    0%,100%{transform:translate(0,0) scale(1);}
    50%{transform:translate(40px,25px) scale(1.05);}
}

/* Floating particles */
.particle {
    position:fixed;
    width:2px; height:2px;
    border-radius:50%;
    background:rgba(255,255,255,0.6);
    animation: float 10s infinite;
    z-index:0;
}

@keyframes float {
    0%,100%{transform:translateY(0) translateX(0); opacity:0;}
    10%,90%{opacity:1;}
    100%{transform:translateY(-100vh) translateX(80px); opacity:0;}
}

/* Container */
.container {
    position:relative;
    z-index:1;
    max-width:100%;
    width:100%;
    background:rgba(255,255,255,0.98);
    padding:5px 35px;
    border-radius:20px;
    box-shadow:0 25px 70px rgba(0,0,0,0.3),0 0 0 1px rgba(255,255,255,0.2);
    backdrop-filter:blur(15px);
    max-height:100vh;
    overflow-y:auto;
}

.container::-webkit-scrollbar { width:8px; }
.container::-webkit-scrollbar-track { background:#f1f1f1; border-radius:10px; }
.container::-webkit-scrollbar-thumb { background: linear-gradient(135deg,#667eea,#764ba2); border-radius:10px; }
.container::-webkit-scrollbar-thumb:hover { background: linear-gradient(135deg,#764ba2,#667eea); }

/* Header Section */
.header-section { text-align:center; margin-bottom:18px; border-bottom:2px solid transparent; background: linear-gradient(90deg, transparent, #667eea, #764ba2, transparent) bottom/70% 2px no-repeat; }
.logo-icon { font-size:1.8rem; margin-bottom:5px; background:linear-gradient(135deg,#667eea 0%,#764ba2 50%,#f093fb 100%); -webkit-background-clip:text; -webkit-text-fill-color:transparent; }
h2 { font-size:1.8rem; font-weight:900; margin-bottom:5px; letter-spacing:-0.5px; background:linear-gradient(135deg,#667eea 0%,#764ba2 50%,#f093fb 100%); background-size:200% auto; -webkit-background-clip:text; -webkit-text-fill-color:transparent; animation:gradientMove 5s ease infinite; }
@keyframes gradientMove { 0%,100%{background-position:0% 50%;} 50%{background-position:100% 50%;} }
.subtitle { color:#64748b; font-size:0.8rem; font-weight:500; letter-spacing:0.3px; margin-bottom:4px; }
.badge-pro { display:inline-block; background:linear-gradient(135deg,#667eea,#764ba2); color:white; padding:3px 14px; border-radius:50px; font-size:0.65rem; font-weight:700; text-transform:uppercase; letter-spacing:0.8px; box-shadow:0 3px 12px rgba(102,126,234,0.4); }

/* Form Grid */
.form-grid { display:grid; grid-template-columns:repeat(3,1fr); gap:15px; }
.form-section { position:relative; overflow:hidden; padding:10px; border-radius:14px; border:2px solid #e8eaf6; background:linear-gradient(135deg,#fafbff 0%,#ffffff 100%); transition: all 0.3s cubic-bezier(0.4,0,0.2,1); }
.form-section::before { content:''; position:absolute; top:0; left:-100%; width:100%; height:100%; background:linear-gradient(90deg, transparent, rgba(102,126,234,0.05), transparent); transition:left 0.5s; }
.form-section:hover::before { left:100%; }
.form-section:hover { transform:translateY(-2px); box-shadow:0 12px 28px rgba(102,126,234,0.15),0 0 0 2px rgba(102,126,234,0.1); border-color:rgba(102,126,234,0.3); }

.form-label { font-weight:700; color:#1e293b; font-size:0.85rem; margin-bottom:8px; display:flex; align-items:center; padding-left:8px; }
.form-label svg { width:18px; height:18px; margin-right:7px; fill:#667eea; }

.form-control { border:2px solid #e8eaf6; border-radius:10px; padding:10px 14px; font-size:0.85rem; font-weight:500; transition:all 0.3s ease; }
.form-control:focus { border-color:#667eea; box-shadow:0 0 0 3px rgba(102,126,234,0.1); }
.form-control[type="file"] { cursor:pointer; border:2px dashed #d0d7de; background:linear-gradient(135deg,#f8f9ff 0%,#ffffff 100%); font-size:0.8rem; padding:12px; }

#imagePreviews { display:flex; flex-wrap:wrap; gap:8px; margin-top:10px; padding:10px; background: linear-gradient(135deg,#ffffff,#fafbff); border-radius:10px; min-height:50px; border:2px dashed #e8eaf6; }
#imagePreviews:empty::before { content:'Preview...'; color:#94a3b8; font-style:italic; font-size:0.75rem; width:100%; text-align:center; padding:8px; }

.preview-img { width:90px; height:90px; object-fit:cover; border-radius:10px; border:3px solid #fff; box-shadow:0 6px 16px rgba(102,126,234,0.15); transition: all 0.3s cubic-bezier(0.4,0,0.2,1); }
.preview-img:hover { transform:scale(1.12) rotate(4deg); border-color:#667eea; box-shadow:0 12px 24px rgba(102,126,234,0.3); z-index:10; }

#visualStyles { display:grid; grid-template-columns:repeat(4,1fr); gap:12px; padding:12px; background:white; border-radius:10px; }
.visual-style-item { text-align:center; cursor:pointer; position:relative; overflow:hidden; border-radius:12px; background:linear-gradient(135deg,#fafbff 0%,#fff 100%); border:2px solid #e8eaf6; padding:28px 0 3px; transition:all 0.3s cubic-bezier(0.4,0,0.2,1); }
.visual-style-item::before { content:''; position:absolute; top:0; left:0; width:100%; height:100%; background:linear-gradient(135deg,rgba(102,126,234,0.08),rgba(118,75,162,0.08)); opacity:0; transition:opacity 0.3s; }
.visual-style-item:hover::before { opacity:1; }
.visual-style-item:hover { transform:translateY(-4px); box-shadow:0 12px 30px rgba(102,126,234,0.2); border-color:#667eea; }
.visual-style-item input[type="checkbox"] { position:absolute; top:8px; right:8px; width:20px; height:20px; cursor:pointer; accent-color:#667eea; z-index:5; }
.visual-style-item label { display:block; font-weight:600; color:#334155; margin-bottom:10px; cursor:pointer; font-size:9px; padding-top:8px; text-transform:uppercase; letter-spacing:0.4px; }
.visual-style-item img { width:100%; height:85px; object-fit:cover; border-radius:8px; border:3px solid #fff; box-shadow:0 6px 16px rgba(102,126,234,0.12); transition:all 0.3s cubic-bezier(0.4,0,0.2,1); }
.visual-style-item:hover img, .visual-style-item input[type="checkbox"]:checked ~ img { border-color:#667eea; transform:scale(1.05); box-shadow:0 0 0 3px rgba(102,126,234,0.2); }

.btn-submit { background:linear-gradient(135deg,#667eea 0%,#764ba2 100%); background-size:200% auto; border:none; font-weight:800; font-size:1rem; border-radius:12px; color:white; text-transform:uppercase; letter-spacing:1.2px; transition: all 0.3s cubic-bezier(0.4,0,0.2,1); box-shadow:0 10px 30px rgba(102,126,234,0.4),0 4px 12px rgba(0,0,0,0.1); position:relative; overflow:hidden; margin-top:8px; }
.btn-submit::before, .btn-submit::after { content:'✨'; position:absolute; top:50%; font-size:1.2rem; transform:translateY(-50%); transition:all 0.3s; }
.btn-submit::before { left:-25px; } .btn-submit::after { right:-25px; }
.btn-submit:hover::before { left:18px; } .btn-submit:hover::after { right:18px; }
.btn-submit:hover { background-position:right center; transform:translateY(-3px); box-shadow:0 18px 45px rgba(102,126,234,0.5),0 6px 20px rgba(0,0,0,0.15); }
.btn-submit:active { transform:translateY(-1px); }

.text-muted { font-size:0.72rem; color:#64748b; margin-top:5px; display:flex; align-items:center; font-weight:500; }
.text-muted::before { content:'💡'; margin-right:5px; font-size:0.8rem; }

/* Preview Section - Below Button */
#aiGallery {
    
    
    background: linear-gradient(135deg, #fafbff 0%, #ffffff 100%);
    border-radius: 14px;
    border: 2px solid #e8eaf6;
    min-height: 100px;
    display: none;
}

#aiGallery.active {
    display: block;
}

#aiGallery .result-card {
    background: white;
    /*padding: 25px;*/
    border-radius: 12px;
    box-shadow: 0 8px 24px rgba(102, 126, 234, 0.12);
    text-align: center;
}

#aiGallery .result-card h5 {
    color: #1e293b;
    font-weight: 700;
    margin-bottom: 20px;
    font-size: 1.3rem;
}

#aiGallery .result-card img {
    max-width: 100%;
    height: auto;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgba(102, 126, 234, 0.2);
    margin-bottom: 20px;
}

#aiGallery .result-card p {
    color: #475569;
    font-size: 0.95rem;
    margin-bottom: 10px;
}

#aiGallery .result-card strong {
    color: #667eea;
    font-weight: 600;
}

/* grid for multiple ai images */
#aiGallery .gallery-grid {
    display:grid;
    grid-template-columns:repeat(auto-fit, minmax(180px, 1fr));
    gap:14px;
    /*margin-top:12px;*/
}

#aiGallery .gallery-item {
    /*background:white;*/
    /*padding:12px;*/
    height: 250px;
    border-radius:10px;
    /*border:1px solid #eef2ff;*/
    text-align:center;
}

#aiGallery .gallery-item img {
    
    height:200px;
    object-fit:cover;
    border-radius:8px;
    margin-bottom:8px;
}

/* responsive tweaks */
@media(max-width:1200px){.form-grid{grid-template-columns:repeat(2,1fr);} #visualStyles{grid-template-columns:repeat(2,1fr);} }
@media(max-width:768px){body{padding:10px;} .container{padding:18px 22px; max-height:98vh;} h2{font-size:1.5rem;} .subtitle{font-size:0.75rem;} .logo-icon{font-size:1.5rem;} .form-grid{grid-template-columns:1fr; gap:12px;} .form-section{padding:8px;} #visualStyles{grid-template-columns:repeat(2,1fr); gap:10px;} .visual-style-item img{height:65px;} .btn-submit{font-size:0.9rem; padding:12px 28px;} }
</style>
</head>
<body>

<!-- Floating Particles -->
<div class="particle" style="left:15%;animation-delay:0s;"></div>
<div class="particle" style="left:35%;animation-delay:3s;"></div>
<div class="particle" style="left:55%;animation-delay:1.5s;"></div>
<div class="particle" style="left:75%;animation-delay:4s;"></div>
<div class="particle" style="left:85%;animation-delay:2s;"></div>

<div class="container animate__animated animate__fadeIn">
    <div class="header-section">
        <div class="logo-icon">✨🎨✨</div>
        <h2>AI Image Story Creator</h2>
        <p class="subtitle">Transform your moments into magical AI-powered visual narratives</p>
        <!--<span class="badge-pro">Professional Edition</span>-->
    </div>
    
    <form id="storyForm" action="generate_test.php" method="POST" enctype="multipart/form-data">
        <div class="form-grid">
            <!-- Image Upload -->
            <div class="form-section">
                <label class="form-label">
                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M21 19V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2zM8.5 13.5l2.5 3.01L14.5 12l4.5 6H5l3.5-4.5z"/></svg>
                    Upload Images (1–5)
                </label>
                <input type="file" name="images[]" id="images" accept="image/*" multiple class="form-control">
                <div id="imagePreviews"></div>
            </div>

            <!-- Life Story Points + Visual Style (MERGED) -->
            <div class="form-section">
                <label class="form-label">
                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M14 2H6c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V8l-6-6zm2 16H8v-2h8v2zm0-4H8v-2h8v2zm-3-5V3.5L18.5 9H13z"/></svg>
                    Life Story Points (Max 5)
                </label>
                <input type="text" name="story_points" id="storyPoints" class="form-control" placeholder="Childhood, College, Career, Wedding, Present">
                <small class="text-muted">Separate with commas</small>
                
                <!-- Visual Style section moved here -->
                <label class="form-label mt-3">
                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M12 3c-4.97 0-9 4.03-9 9s4.03 9 9 9c.83 0 1.5-.67 1.5-1.5 0-.39-.15-.74-.39-1.01-.23-.26-.38-.61-.38-.99 0-.83.67-1.5 1.5-1.5H16c2.76 0 5-2.24 5-5 0-4.42-4.03-8-9-8zm-5.5 9c-.83 0-1.5-.67-1.5-1.5S5.67 9 6.5 9 8 9.67 8 10.5 7.33 12 6.5 12zm3-4C8.67 8 8 7.33 8 6.5S8.67 5 9.5 5s1.5.67 1.5 1.5S10.33 8 9.5 8zm5 0c-.83 0-1.5-.67-1.5-1.5S13.67 5 14.5 5s1.5.67 1.5 1.5S15.33 8 14.5 8zm3 4c-.83 0-1.5-.67-1.5-1.5S16.67 9 17.5 9s1.5.67 1.5 1.5-.67 1.5-1.5 1.5z"/></svg>
                    Choose Visual Style
                </label>
                <div id="visualStyles">
                    <div class="visual-style-item">
                        <input type="checkbox" name="visual_style" value="medieval" id="styleMedieval">
                        <label for="styleMedieval">Medieval</label>
                        <img src="https://bclix.tech/shopify-custom-app/images/medieval1.jpg" alt="Medieval Style">
                    </div>
                    <div class="visual-style-item">
                        <input type="checkbox" name="visual_style" value="futuristic" id="styleFuturistic">
                        <label for="styleFuturistic">Futuristic</label>
                        <img src="https://bclix.tech/shopify-custom-app/images/Futuristic.webp" alt="Futuristic Style">
                    </div>
                    <div class="visual-style-item">
                        <input type="checkbox" name="visual_style" value="comic" id="styleComic">
                        <label for="styleComic">Comic</label>
                        <img src="https://bclix.tech/shopify-custom-app/images/Comic1.jfif" alt="Comic Style">
                    </div>
                    <div class="visual-style-item">
                        <input type="checkbox" name="visual_style" value="watercolor" id="styleWatercolor">
                        <label for="styleWatercolor">Watercolor</label>
                        <img src="https://bclix.tech/shopify-custom-app/images/Watercolor.jpg" alt="Watercolor Style">
                    </div>
                </div>
            </div>

            <!-- Preview Section (ONLY PREVIEW) -->
            <div class="form-section">
                <label class="form-label">
                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M21 19V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2zM8.5 13.5l2.5 3.01L14.5 12l4.5 6H5l3.5-4.5z"/></svg>
                    Preview
                </label>
                <div id="aiGallery"></div>
            </div>
        </div>

        <div class="text-center">
            <button type="submit" class="btn btn-submit w-50 mx-auto">Generate AI Story</button>
        </div>
    </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
// --- Image Preview ---
const imagesInput = document.getElementById('images');
const previewContainer = document.getElementById('imagePreviews');

imagesInput.addEventListener('change', function() {
    const files = Array.from(this.files);
    if (files.length > 5) {
        alert('You can upload maximum 5 images!');
        this.value = '';
        previewContainer.innerHTML = '';
        return;
    }
    previewContainer.innerHTML = '';
    files.forEach(file => {
        const reader = new FileReader();
        reader.onload = function(e){
            const img = document.createElement('img');
            img.src = e.target.result;
            img.classList.add('preview-img', 'animate__animated','animate__fadeIn');
            previewContainer.appendChild(img);
        };
        reader.readAsDataURL(file);
    });
});

// --- Visual Style Single Select ---
const styleCheckboxes = document.querySelectorAll('input[name="visual_style"]');
styleCheckboxes.forEach(cb => cb.addEventListener('click', function(){
    styleCheckboxes.forEach(other => { if(other!==cb) other.checked=false; });
}));

// --- Form Submission ---
document.getElementById('storyForm').addEventListener('submit', async function(e){
    e.preventDefault();
    const formData = new FormData(this);
    const aiGallery = document.getElementById('aiGallery');
    const submitBtn = this.querySelector('button[type="submit"]');

    // simple client-side validation
    const files = document.getElementById('images').files;
    if(files.length === 0){
        if(!confirm('No reference images uploaded. Continue?')) return;
    }
    const storyText = document.getElementById('storyPoints').value.trim();
    if(!storyText){
        alert('Please enter at least one story point (comma separated).');
        return;
    }
    // ensure a style selected
    const styleSelected = Array.from(styleCheckboxes).some(cb => cb.checked);
    if(!styleSelected){
        alert('Please select a visual style.');
        return;
    }

    submitBtn.disabled = true;
    submitBtn.innerText = "⏳ Generating...";
    aiGallery.classList.add('active');
    aiGallery.innerHTML = "<p class='text-center text-muted mt-3'>Generating story... please wait...</p>";

    try {
        const res = await fetch('generate_test.php', { method:'POST', body:formData });
        // if not JSON, show raw text
        const text = await res.text();
        let data;
        try { data = JSON.parse(text); } catch(e) {
            // server returned non-json (maybe binary or error)
            aiGallery.innerHTML = `<p class="text-danger text-center mt-3">❌ Unexpected server response. Check server logs.</p>`;
            submitBtn.disabled = false;
            submitBtn.innerText = "Generate AI Story";
            console.error('Raw server response:', text);
            return;
        }

        submitBtn.disabled = false;
        submitBtn.innerText = "Generate AI Story";

        // ✅ Multiple images expected in data.ai_images (array)
        if(data.status === 'success'){
            const images = Array.isArray(data.ai_images) ? data.ai_images : (data.ai_image ? [data.ai_image] : []);
            if(images.length === 0){
                aiGallery.innerHTML = `<p class="text-danger text-center mt-3">⚠️ No images were returned by the server.</p>`;
                console.warn('Server response (no images):', data);
                return;
            }

            // Build gallery HTML
            let galleryHtml = `
                <div class="result-card animate__animated animate__fadeIn">
                    
                    <div class="gallery-grid">
            `;

            images.forEach((imgUrl, idx) => {
                // display each image with scene number
                galleryHtml += `
                    <div class="gallery-item">
                        <img src="${escapeAttr(imgUrl)}" alt="AI Image ${idx+1}">
                       
                        <div style="margin-top:6px;">
                            <a href="${escapeAttr(imgUrl)}" target="_blank" class="btn btn-sm btn-outline-primary">Open</a>
                            <a href="${escapeAttr(imgUrl)}" download class="btn btn-sm btn-outline-success">Download</a>
                        </div>
                    </div>
                `;
            });

            galleryHtml += `</div></div>`;
            aiGallery.innerHTML = galleryHtml;
            // scroll to gallery
            aiGallery.scrollIntoView({ behavior: 'smooth' });
        } 
        // ⚠️ Error Response
        else {
            console.log('Full server response:', data);
            const errorMessage = data?.message || 'Unknown error occurred.';
            aiGallery.innerHTML = `<p class="text-danger text-center mt-3">⚠️ ${escapeHtml(errorMessage)}</p>`;
            console.log('Error message:', errorMessage);
        }
    } catch(err) {
        console.error(err);
        aiGallery.innerHTML = `<p class="text-danger text-center mt-3">❌ Error generating story.</p>`;
        submitBtn.disabled = false;
        submitBtn.innerText = "Generate AI Story";
    }
});

// small helpers to avoid XSS if server returns values (kept safe)
function escapeHtml(s){
    if(!s) return '';
    return String(s).replace(/[&<>"'`=\/]/g, function (c) {
        return {'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;','/':'&#x2F;','`':'&#x60;','=':'&#x3D;'}[c];
    });
}
function escapeAttr(s){
    return escapeHtml(s).replace(/"/g, '&quot;');
}
</script>

</body>
</html>