<?php
// ====== CORS FIX ======
$allowed_origins = [
    'https://mydreamz.ai',
    'https://zvgr1k-mt.myshopify.com',
    'https://bclix.tech'
];

$origin = $_SERVER['HTTP_ORIGIN'] ?? '';

if (in_array($origin, $allowed_origins)) {
    header("Access-Control-Allow-Origin: $origin");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
}

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json');


$api_key = "AIzaSyC90O0wEx7jj77IwHPVZBd9GoZfFtHDSeY";

$uploadDir = "uploads/";
$outputDir = "outputs/";
$serverBaseURL = "https://bclix.tech/shopify-custom-app/";
// // Directories agar exist na karen to banayen
if (!file_exists($uploadDir)) mkdir($uploadDir, 0777, true);
if (!file_exists($outputDir)) mkdir($outputDir, 0777, true);

$uploadedImages = [];

if (!empty($_FILES['images'])) {
    $files = $_FILES['images'];
    $count = is_array($files['name']) ? count($files['name']) : 1;
    for ($i = 0; $i < $count; $i++) {
        $name = is_array($files['name']) ? $files['name'][$i] : $files['name'];
        $tmp_name = is_array($files['tmp_name']) ? $files['tmp_name'][$i] : $files['tmp_name'];
        $fileName = time() . "_" . basename($name);
        $target = $uploadDir . $fileName;
        if (move_uploaded_file($tmp_name, $target)) {
            $uploadedImages[] = $target;
        }
    }
}

$storyPointsInput = $_POST['story_points'] ?? '';
$visualStyle = $_POST['visual_style'] ?? '';

if (empty($storyPointsInput)) {
    echo json_encode(["status" => "error", "message" => "Please enter at least one story point."]);
    exit;
}
if (empty($visualStyle)) {
    echo json_encode(["status" => "error", "message" => "Please select a visual style."]);
    exit;
}

$storyPoints = is_array($storyPointsInput)
    ? array_map('trim', $storyPointsInput)
    : array_map('trim', explode(',', $storyPointsInput));

$storyPoints = array_slice($storyPoints, 0, 5);

$storyText = implode('. ', $storyPoints);

$url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.5-flash-image:generateContent";

$generatedImages = [];

// Get number of inline scenes user wants in a single image
$sceneCount = intval($_POST['scene_count'] ?? 3);
if ($sceneCount < 1 || $sceneCount > 5) $sceneCount = 3;

$storyText = implode('. ', $storyPoints);

$panelDescriptions = [];
foreach ($storyPoints as $i => $moment) {
    $panelNum = $i + 1;
    $panelDescriptions[] = "* **Panel {$panelNum}:** The character experiencing '{$moment}'.";
}

// Pad to 5 for heredoc safety
for ($i = count($panelDescriptions); $i < 5; $i++) {
    $panelDescriptions[$i] = '';
}

// Grid layout
$layoutPanels = count($storyPoints);
$gridLayout = ($layoutPanels <= 4) ? "{$layoutPanels} separate panels" : "a {$layoutPanels}-panel grid";

// Assign panel variables
$panel0 = $panelDescriptions[0];
$panel1 = $panelDescriptions[1];
$panel2 = $panelDescriptions[2];
$panel3 = $panelDescriptions[3];
$panel4 = $panelDescriptions[4];

// Prompt
$prompt = <<<EOT
CORE INSTRUCTION: Generate ONE high-resolution composite illustration (>=3000px longest side).

STRUCTURE:
1.  **Layout:** The canvas MUST be a **{$gridLayout}**, visually separated by soft borders (storybook frame style).
2.  **Scene Sequence:** 
   $panel0
   $panel1
   $panel2
   $panel3
   $panel4

VISUAL STYLE & MOOD:
* **Style:** `{$visualStyle}` — **Realistic**, soft fairytale illustration, **painterly brush strokes**, storybook texture.
* **Color/Light:** **Soft pastel and jewel-toned colors**, subtle magical atmosphere, **cinematic, dramatic lighting** with strong **golden light reflections**.
* **Consistency:** The overall mood and art style must be **IDENTICAL** across all panels.

CHARACTER CONSISTENCY (Strict):
* Use the **EXACT** person from the uploaded photo as the main subject in all panels.
* **Maintain 100% identical face, hairstyle, facial features, and body proportions** across every single scene to ensure seamless continuity.

CONSTRAINTS:
* NO text overlays, NO watermarks, NO extra people/animals (unless contextually mandatory).
* NO cartoon distortions; adhere to **realistic/painterly** style.

Output: Generate exactly ONE image containing {$layoutPanels} inline illustrated scenes in the '{$visualStyle}' style, showing the real person(s) blended harmoniously into this illustrated world.
EOT;


// file_put_contents('gemini_prompt.json', $prompt);
// die();
// ---------- Build request parts ----------
$parts = [["text" => $prompt]];

// If photo uploaded, attach as inline image data
if (!empty($uploadedImages)) {
    $imagePath = $uploadedImages[0]; // use first image as reference
    if (file_exists($imagePath)) {
        $imageData = base64_encode(file_get_contents($imagePath));
        $mime_type = mime_content_type($imagePath) ?: 'image/png';
        $parts[] = [
            "inline_data" => [
                "mime_type" => $mime_type,
                "data" => $imageData
            ]
        ];
    }
}

$payload = ["contents" => [["parts" => $parts]]];
// file_put_contents('debug_payload.json', json_encode($payload, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
// die();
// Send request to Gemini API
$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json",
        "x-goog-api-key: $api_key"
    ],
    CURLOPT_POSTFIELDS => json_encode($payload)
]);
$response = curl_exec($ch);
file_put_contents('debug_gemini_response.json', $response);
curl_close($ch);

$decoded = json_decode($response, true);

// Extract base64 image
$img_base64 = null;
if (isset($decoded['candidates'][0]['content']['parts'])) {
    foreach ($decoded['candidates'][0]['content']['parts'] as $part) {
        if (isset($part['inlineData']['data'])) {
            $img_base64 = $part['inlineData']['data'];
            break;
        }
    }
}

if ($img_base64) {
    $img_data = base64_decode($img_base64);
    $file_name = "gemini_story_" . time() . ".png";
    $output_path = $outputDir . $file_name;

    if (file_put_contents($output_path, $img_data) === false) {
        echo json_encode(["status" => "error", "message" => "Failed to save generated image."]);
        exit;
    }

    $generatedImages[] = $serverBaseURL . "outputs/" . $file_name;
    echo json_encode([
        "status" => "success",
        "ai_images" => $generatedImages,
        "file_name" => $file_name,
        "story_points" => $storyPoints,
        "visual_style" => $visualStyle,
        "scene_count" => $sceneCount,
        "message" => "Successfully generated one composite image with {$sceneCount} inline scenes."
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "No image data found in Gemini response.",
        "response_sample" => substr($response, 0, 400)
    ]);
}
exit;
