<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

$output_file = null;
$output_url = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $api_key = "AIzaSyC90O0wEx7jj77IwHPVZBd9GoZfFtHDSeY";

    if (empty($_FILES['image']['tmp_name'])) {
        echo "<p style='color:red;'>Please upload an image file.</p>";
        exit;
    }
    if (empty($_POST['prompt'])) {
        echo "<p style='color:red;'>Please provide a text prompt.</p>";
        exit;
    }

    $image_data = file_get_contents($_FILES['image']['tmp_name']);
    $image_base64 = base64_encode($image_data);

    $mime_type = mime_content_type($_FILES['image']['tmp_name']);
    $prompt = $_POST['prompt'];

    $payload = [
        "contents" => [
            [
                "parts" => [
                    ["text" => $prompt],
                    [
                        "inline_data" => [
                            "mime_type" => $mime_type,
                            "data" => $image_base64
                        ]
                    ]
                ]
            ]
        ]
    ];
    
    
echo json_encode($payload);
die();
    $url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.5-flash-image:generateContent";

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => [
            "Content-Type: application/json",
            "x-goog-api-key: $api_key"
        ],
        CURLOPT_POSTFIELDS => json_encode($payload)
    ]);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    $decoded = json_decode($response, true);

    if ($http_code == 200 && isset($decoded['candidates'][0]['content']['parts'][0]['inlineData']['data'])) {
        $img_base64 = $decoded['candidates'][0]['content']['parts'][0]['inlineData']['data'];
        $img_data = base64_decode($img_base64);

        $outputDir = __DIR__ . "/outputs/";
        if (!file_exists($outputDir)) {
            if (!mkdir($outputDir, 0777, true)) {
                echo "<p style='color:red;'>Failed to create output directory.</p>";
                exit;
            }
        }

        $output_file = $outputDir . "edited_" . time() . ".png";

        if (file_put_contents($output_file, $img_data) === false) {
            echo "<p style='color:red;'>Failed to save image file.</p>";
            exit;
        }

        $output_url = "outputs/" . basename($output_file);

    } else {
        echo "<p style='color:red;'>Failed to generate image. HTTP Code: $http_code</p>";
        echo "<pre>" . htmlentities($response) . "</pre>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Gemini Image Editing Test</title>
</head>
<body>
<h1>Gemini Image Editing API Test</h1>
<form method="POST" enctype="multipart/form-data">
    <label>Select an image to edit:</label><br>
    <input type="file" name="image" accept="image/*" required><br><br>

    <label>Text prompt for editing:</label><br>
    <textarea name="prompt" rows="3" cols="50" placeholder="E.g. Create a picture of my cat eating a nano-banana in a fancy restaurant under the Gemini constellation" required></textarea><br><br>

    <button type="submit">Generate Edited Image</button>
</form>

<?php
if (!empty($output_url)) {
    echo "<h2>Generated Image:</h2>";
    echo "<img src='$output_url' style='max-width:500px; border:1px solid #333;' />";
}
?>
</body>
</html>
