<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

$output_files = []; // Multiple generated images URLs

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $api_key = "AIzaSyC90O0wEx7jj77IwHPVZBd9GoZfFtHDSeY";

    if (empty($_FILES['image']['tmp_name'])) {
        echo "<p style='color:red;'>Please upload an image file.</p>";
        exit;
    }
    if (empty($_POST['prompt'])) {
        echo "<p style='color:red;'>Please provide a text prompt.</p>";
        exit;
    }
    if (empty($_POST['visual_style'])) {
        echo "<p style='color:red;'>Please select a visual style.</p>";
        exit;
    }

    $image_data = file_get_contents($_FILES['image']['tmp_name']);
    $image_base64 = base64_encode($image_data);

    $mime_type = mime_content_type($_FILES['image']['tmp_name']);
    $prompt = $_POST['prompt'];
    $visual_style = $_POST['visual_style'];

    $outputDir = __DIR__ . "/outputs/";
    if (!file_exists($outputDir)) {
        if (!mkdir($outputDir, 0777, true)) {
            echo "<p style='color:red;'>Failed to create output directory.</p>";
            exit;
        }
    }

    $url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.5-flash-image:generateContent";

    // Generate 5 images in loop
    for ($i = 1; $i <= 5; $i++) {
        // Build prompt per iteration to reflect scene number and visual style
        $scene_prompt = $prompt . " Visual style: " . $visual_style . ". Scene " . $i . "/5.";

        $payload = [
            "contents" => [
                [
                    "parts" => [
                        ["text" => $scene_prompt],
                        [
                            "inline_data" => [
                                "mime_type" => $mime_type,
                                "data" => $image_base64
                            ]
                        ]
                    ]
                ]
            ]
        ];

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => [
                "Content-Type: application/json",
                "x-goog-api-key: $api_key"
            ],
            CURLOPT_POSTFIELDS => json_encode($payload)
        ]);

        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curl_error = curl_error($ch);
        curl_close($ch);

        if ($curl_error) {
            echo "<p style='color:red;'>Curl Error on image $i: $curl_error</p>";
            exit;
        }

        $decoded = json_decode($response, true);

        if ($http_code == 200 && isset($decoded['candidates'][0]['content']['parts'][1]['inline_data']['data'])) {
            $img_base64_resp = $decoded['candidates'][0]['content']['parts'][1]['inline_data']['data'];
            $img_data = base64_decode($img_base64_resp);

            $output_file = $outputDir . "edited_" . time() . "_$i.png";

            if (file_put_contents($output_file, $img_data) === false) {
                echo "<p style='color:red;'>Failed to save image file $i.</p>";
                exit;
            }

            $output_files[] = "outputs/" . basename($output_file);
        } else {
            echo "<p style='color:red;'>Failed to generate image $i. HTTP Code: $http_code</p>";
            echo "<pre>" . htmlentities($response) . "</pre>";
            exit;
        }

        // small delay to avoid rate limits (optional)
        usleep(500000); // 0.5 seconds
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Gemini Image Editing Test - Multiple Images</title>
</head>
<body>
<h1>Gemini Image Editing API Test - Generate 5 Images</h1>
<form method="POST" enctype="multipart/form-data">
    <label>Select an image to edit:</label><br>
    <input type="file" name="image" accept="image/*" required><br><br>

    <label>Text prompt for editing:</label><br>
    <textarea name="prompt" rows="3" cols="50" placeholder="E.g. Create a picture of my cat eating a nano-banana in a fancy restaurant under the Gemini constellation" required><?php echo isset($_POST['prompt']) ? htmlentities($_POST['prompt']) : ''; ?></textarea><br><br>

    <label>Select visual style:</label><br>
    <select name="visual_style" required>
        <option value="">--Select Style--</option>
        <option value="realistic" <?php if(isset($_POST['visual_style']) && $_POST['visual_style']=='realistic') echo 'selected'; ?>>Realistic</option>
        <option value="futuristic" <?php if(isset($_POST['visual_style']) && $_POST['visual_style']=='futuristic') echo 'selected'; ?>>Futuristic</option>
        <option value="cartoon" <?php if(isset($_POST['visual_style']) && $_POST['visual_style']=='cartoon') echo 'selected'; ?>>Cartoon</option>
        <option value="surreal" <?php if(isset($_POST['visual_style']) && $_POST['visual_style']=='surreal') echo 'selected'; ?>>Surreal</option>
        <option value="abstract" <?php if(isset($_POST['visual_style']) && $_POST['visual_style']=='abstract') echo 'selected'; ?>>Abstract</option>
    </select><br><br>

    <button type="submit">Generate 5 Edited Images</button>
</form>

<?php
if (!empty($output_files)) {
    echo "<h2>Generated Images:</h2>";
    foreach ($output_files as $img_url) {
        echo "<img src='$img_url' style='max-width:300px; margin:10px; border:1px solid #333;' />";
    }
}
?>
</body>
</html>
