<?php 
header('Content-Type: application/json');

// 🔑 Google Gemini API Key
$api_key = "AIzaSyC90O0wEx7jj77IwHPVZBd9GoZfFtHDSeY"; // 👈 apni key lagao

// 📁 Upload folder for user images
$uploadDir = "uploads/";
if (!file_exists($uploadDir)) mkdir($uploadDir, 0777, true);

// 📁 Output folder for AI-generated images
$outputDir = "outputs/";
if (!file_exists($outputDir)) mkdir($outputDir, 0777, true);

// 🖼️ Collect uploaded image (from frontend)
$imageUrl = '';
if (!empty($_FILES['images']['name'][0])) {
    $fileName = time() . "_" . basename($_FILES['images']['name'][0]);
    $target = $uploadDir . $fileName;
    if (move_uploaded_file($_FILES['images']['tmp_name'][0], $target)) {
        // 👇 Optional: Agar tum local image ko public URL banana chahtay ho
        // usko apne domain/server path se replace kar do
        $imageUrl = $target;
    }
}

// 📝 Collect user input from frontend
$storyPoints = $_POST['story_points'] ?? '';
$visualStyle = $_POST['visual_style'] ?? '';

// 🧩 Validation
if (empty($storyPoints)) {
    echo json_encode([
        "status" => "error",
        "message" => "Please enter story points."
    ]);
    exit;
}

// 🎨 Build AI prompt
$prompt = "Generate 5 AI variations based on the uploaded image with the concept: {$storyPoints}.";

// 🧠 Gemini Imagen 4.0 Endpoint
$url = "https://generativelanguage.googleapis.com/v1beta/models/imagen-4.0-generate-001:predict?key={$api_key}";

// 📦 Build JSON payload (Dynamic - no hardcoding)
$payload = [
    "instances" => [
        [
            "prompt" => $prompt
        ]
    ],
    "parameters" => [
        "sampleCount" => 5
    ]
];

// Agar frontend se image di gayi ho (public ya hosted)
if (!empty($imageUrl)) {
    // ⚠️ Gemini API sirf public URLs accept karti hai
    $payload["instances"][0]["image"] = [
        "url" => $imageUrl
    ];
}

// Agar visual style diya gaya ho
if (!empty($visualStyle)) {
    $payload["instances"][0]["visualization_type"] = $visualStyle;
}

// 🚀 CURL request to Gemini API
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json"
    ],
    CURLOPT_POSTFIELDS => json_encode($payload)
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

// 🖼️ Handle response
if ($http_code === 200 && !empty($response)) {
    $decoded = json_decode($response, true);

    echo json_encode([
        "status" => "success",
        "prompt" => $prompt,
        "visual_style" => $visualStyle,
        "story_points" => $storyPoints,
        "api_response" => $decoded
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "⚠️ Failed to generate image from Gemini API.",
        "http_code" => $http_code,
        "curl_error" => $error,
        "response_preview" => substr($response, 0, 300)
    ]);
}
?>
